<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van PRPM_IN907120NL02 - Get Applications of an AssignedEntity, Query Response</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <pattern is-a="transmission-wrapper" id="PRPM_IN907120NL02-wrapper">
        <param name="element" value="hl7:PRPM_IN907120NL02"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="PRPM_IN907120NL02-controlAct">
        <param name="element" value="hl7:PRPM_IN907120NL02/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:PRPM_IN907120NL02/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:PRPM_IN907120NL02/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:PRPM_IN907120NL02/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <!-- sender -->
        <rule context="hl7:PRPM_IN907120NL02/hl7:sender/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet een AORTA applicatie zijn, en moet de ZIM zijn</assert>
        </rule>
        <!-- receiver -->
        <rule context="hl7:PRPM_IN907120NL02/hl7:receiver/hl7:device/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
  
    <pattern>
        <title>subject/assignedEntity</title>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:id">
            <extends rule="II"/>
            <assert role="warning" test="@root='2.16.528.1.1007.3.3' or (@root='2.16.840.1.113883.2.4.3.11' and @extension='7') or @root='2.16.840.1.113883.2.4.3.11.25' or @root='2.16.840.1.113883.2.4.3.11.10'"
                ><name path=".."/>/<name/> is onbekend (@root='<value-of select="@root"/>' @extension='<value-of select="@extension"/>'). Verwachte waarden zijn '2.16.528.1.1007.3.3' (URA), '2.16.840.1.113883.2.4.3.11' / '7' (Klantenloket), '2.16.840.1.113883.2.4.3.11.25' (GBO/GBP), '2.16.840.1.113883.2.4.3.11.10' (organisatiedelen)</assert>
        </rule>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo">
            <assert role="error" test="@typeCode='REL'"
                >assignedEntity/relatedTo/@typeCode moet 'REL' bevatten</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/assignedEntity/relatedTo/assignedDevice</title>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo/hl7:assignedDevice/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6'"
                >assignedDevice/id/@root moet '2.16.840.1.113883.2.4.6.6' bevatten</assert>
        </rule>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo/hl7:assignedDevice/hl7:telecom">
            <extends rule="TEL"/>
            <assert role="error" test="matches(@value,'^https?://[^/]+$')"
                >assignedDevice/telecom/@value moet URI-scheme http of https hebben en verder alleen hostnaam of ip-adres en eventueel een poortnummer bevatten</assert>
            <assert role="error" test="matches(@value,'^https?://[^:]+(:[0-9]+)?/?$')"
                >assignedDevice/telecom/@value moet, indien aanwezig, een numeriek poortnummer hebben</assert>
        </rule>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo/hl7:assignedDevice/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error"
                test="@code='active' or @code='suspended' or @code='terminated'"
                >assignedDevice/statusCode mag alleen 'active', 'suspended', of 'terminated' bevatten</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/assignedEntity/relatedTo/assignedDevice/part/qualifiedApplicationRole</title>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:code">
            <extends rule="CE"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.2.4.3.11.3'"
                >qualifiedApplicationRole/code moet komen uit '2.16.840.1.113883.2.4.3.11.3'</assert>
        </rule>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error"
                test="@code='active' or @code='suspended' or @code='terminated'"
                >qualifiedApplicationRole/statusCode mag alleen 'active', 'suspended' of 'terminated' bevatten</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>subject/assignedEntity/relatedTo/assignedDevice/part/qualifiedApplicationRole/reusableDeviceOf/informEvent</title>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:reusableDeviceOf/hl7:informEvent/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.1.6'"
                >informEvent/id moet komen uit '2.16.840.1.113883.1.6' (InteractionId's)</assert>
        </rule>
        <rule context="hl7:subject/hl7:assignedEntity/hl7:relatedTo/hl7:assignedDevice/hl7:part/hl7:qualifiedApplicationRole/hl7:reusableDeviceOf/hl7:informEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.5.4'"
                >informEvent/code moet komen uit '2.16.840.1.113883.5.4' (ActCode)</assert>
            <assert role="error" test="@code='DIRSEND' or @code='DIRREC' or @code='BIDIR'"
                >informEvent/code moet één van DIRREC, DIRSEND of BIDIR zijn</assert>
        </rule>
    </pattern>
</schema>
